/* _Getfld function */
#include <ctype.h>
#include <string.h>
#include "xstdio.h"
_STD_BEGIN

int _Getfld(_Sft *px)
	{	/* convert a field */
	px->stored = 0;
	switch (*px->s)
		{	/* switch on conversion specifier */
	case 'c':	/* convert an array of char */
		return (_Getstr(px, 0));

	case 'p':	/* convert a pointer */
	case 'd': case 'i': case 'o':
	case 'u': case 'x': case 'X':
		return (_Getint(px));	/* convert an integer */

	case 'e': case 'E':
	case 'g': case 'G':
	case 'f': case 'F':
	case 'a': case 'A':
		return (_Getfloat(px));	/* convert a floating */

	case 'n':	/* return input count */
		if (!px->noconv)
			switch (px->qual)
				{	/* store in specified integer type */
			case 'b':
				*va_arg(px->ap, signed char *) = (signed char)px->nchar;
				break;

			case 'q':
				*va_arg(px->ap, _Longlong *) = px->nchar;
				break;

			case 'j':
				*va_arg(px->ap, intmax_t *) = px->nchar;
				break;

			case 't':
				*va_arg(px->ap, ptrdiff_t *) = px->nchar;
				break;

			case 'z':
				*va_arg(px->ap, size_t *) = px->nchar;
				break;

			case 'h':
				*va_arg(px->ap, short *) = (short)px->nchar;
				break;

			case 'l':
				*va_arg(px->ap, long *) = px->nchar;
				break;

			default:
				*va_arg(px->ap, int *) = px->nchar;
				}
		return (1);

	case 'S':	/* convert a wide string -- nonstandard */
		px->qual = 'l';	/* fall through */

	case 's':	/* convert a string */
		return (_Getstr(px, 1));

	case '%':
		 {	/* match a '%' */
		int ch;

		if ((ch = GET(px)) == '%')
			return (1);
		UNGETN(px, ch);
		return (ch == EOF ? EOF : 0);
		 }

	case '[':	/* convert a scan set */
		return (_Getstr(px, -1));

	default:	/* undefined specifier, quit */
		return (0);
		}
		}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
